# AllPays Translations

This directory contains translation files for the AllPays WooCommerce plugin.

## Supported Languages

- German (de)
- Italian (it)
- Spanish (es)
- Turkish (tr)
- Russian (ru)
- French (fr)

## Translation Process

1. The translation files are generated using the `bin/generate-translations.php` script.
2. Each language has its own `.po` file in this directory.
3. To add a new translation:
   - Open the `.po` file for your language using a translation tool like Poedit
   - Translate all strings
   - Save the file
   - The tool will automatically generate the corresponding `.mo` file

## Adding New Languages

To add support for a new language:

1. Add the language code and name to the `$supported_languages` array in `includes/core/class-translations.php`
2. Run the `bin/generate-translations.php` script
3. Translate the generated `.po` file
4. Commit both the `.po` and `.mo` files

## Translation Guidelines

1. Keep translations natural and idiomatic
2. Maintain the same formatting and placeholders as the original strings
3. Use appropriate formal/informal tone based on the language
4. Test the translations in the plugin to ensure they fit in the UI

## Contributing Translations

1. Fork the repository
2. Create a new branch for your translation
3. Update the translation files
4. Submit a pull request

## Tools

Recommended tools for translation:

- [Poedit](https://poedit.net/) - A popular translation editor
- [Lokalise](https://lokalise.com/) - A professional translation management system
- [Transifex](https://www.transifex.com/) - A collaborative translation platform
