<?php
/**
 * Utilities
 *
 * @package AllPays
 */

namespace AllPays\Core;

defined( 'ABSPATH' ) || exit;

/**
 * Utils Class
 * Handles utility functions
 */
class Utils {

	/**
	 * Initialize cart fees hook
	 *
	 * @return void
	 */
	public static function init_cart_fees() {
		add_action( 'woocommerce_cart_calculate_fees', array( __CLASS__, 'calculate_cart_fees' ), 10, 1 );
	}

	/**
	 * Calculate cart fees
	 *
	 * @param \WC_Cart $cart Cart object.
	 * @return void
	 */
	public static function calculate_cart_fees( $cart ) {
		if ( ! defined( 'DOING_AJAX' ) && is_admin() ) {
			return;
		}

		$draft_order_id = wc()->session->get( 'store_api_draft_order' );
		if ( $draft_order_id ) {
			$draft_order = wc_get_order( $draft_order_id );
			if ( $draft_order ) {
				$payment_method = $draft_order->get_payment_method();
			}
		} else {
			$payment_method = WC()->session->get( 'chosen_payment_method' );
		}

		if ( empty( $payment_method ) ) {
			return;
		}

		// Check if it's our payment gateway.
		if ( 0 !== strpos( $payment_method, 'allpaysco_' ) ) {
			return;
		}

		$gateway = WC()->payment_gateways->payment_gateways()[ $payment_method ] ?? null;
		if ( ! $gateway ) {
			return;
		}

		$fee_input = get_option( ALLPAYSCO_SETTINGS_ID . '_fee', '' );
		if ( empty( $fee_input ) ) {
			return;
		}

		$is_discount   = str_contains( $fee_input, '-' );
		$is_percentage = str_contains( $fee_input, '%' );
		$fee_amount    = (float) str_replace( array( '%', '-' ), '', $fee_input );

		if ( $is_percentage ) {
			$cart_total = $cart->subtotal + $cart->shipping_total;
			$fee        = ( $fee_amount / 100 ) * $cart_total;
			$decimals   = wc_get_price_decimals();
			$fee        = floor( $fee * pow( 10, $decimals ) ) / pow( 10, $decimals );
		} else {
			$fee = $fee_amount;
		}

		if ( $is_discount ) {
			$fee = -$fee;
		}

		if ( $is_discount ) {
			/* translators: %s: Payment gateway title */
			$label = sprintf( __( '%1$s Discount (%2$s)', 'allpaysco-payment-gateway-for-woocommerce' ), $gateway->get_title(), $fee_input );
		} else {
			/* translators: %s: Payment gateway title */
			$label = sprintf( __( '%1$s Fee (%2$s)', 'allpaysco-payment-gateway-for-woocommerce' ), $gateway->get_title(), $fee_input );
		}

		$cart->add_fee( $label, $fee );
	}
}
